<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

abstract class XenCentral_AdServer_ControllerAdmin_Abstract extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		// check permissions here
	}

    /**
	 * Get product options model
	 * @return XenCentral_AdServer_Model_Options
	 */
	protected function _getOptionsModel()
	{
		return $this->getModelFromCache('XenCentral_AdServer_Model_Options');
	}

    /**
     * Get zone model
     * @return XenCentral_AdServer_Model_Zone
     */
    protected function _getZoneModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_Zone');
    }

    /**
     * Get zone model
     * @return XenCentral_AdServer_Model_Banner
     */
    protected function _getBannerModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_Banner');
    }

    /**
     * @return XenCentral_AdServer_Model_Stats
     */
    protected function _getStatsModel()
    {
        return $this->getModelFromCache('XenCentral_AdServer_Model_Stats');
    }

    /**
     * @return XenCentral_Framework_Model_Cache
     */
    protected function _getCacheModel()
    {
        return $this->getModelFromCache('XenCentral_Framework_Model_Cache');
    }

    /**
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    }


    /**
     * @return XenForo_Model_Option
     */
    protected function _getXenForoOptionModel()
    {
        return $this->getModelFromCache('XenForo_Model_Option');
    }


}
